<?php $__env->startSection('title', 'Doctors'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Doctors</h1>
    <a href="<?php echo e(route('admin.doctors.create')); ?>" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Add New Doctor
    </a>
</div>

<div class="card">
    <div class="card-body">
        <?php if($doctors->count() > 0): ?>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Image</th>
                        <th>Name</th>
                        <th>Specialization</th>
                        <th>Experience</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <?php if($doctor->image): ?>
                                <img src="<?php echo e(asset('storage/' . $doctor->image)); ?>" alt="<?php echo e($doctor->name); ?>" style="width: 50px; height: 50px; object-fit: cover; border-radius: 50%;">
                            <?php else: ?>
                                <i class="bi bi-person-circle" style="font-size: 2rem;"></i>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($doctor->name); ?></td>
                        <td><?php echo e($doctor->specialization); ?></td>
                        <td><?php echo e($doctor->experience_years); ?> years</td>
                        <td>
                            <span class="badge bg-<?php echo e($doctor->is_active ? 'success' : 'secondary'); ?>">
                                <?php echo e($doctor->is_active ? 'Active' : 'Inactive'); ?>

                            </span>
                        </td>
                        <td>
                            <a href="<?php echo e(route('admin.doctors.show', $doctor)); ?>" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                            <a href="<?php echo e(route('admin.doctors.edit', $doctor)); ?>" class="btn btn-sm btn-warning">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <form action="<?php echo e(route('admin.doctors.destroy', $doctor)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this doctor?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
        <p class="text-muted mb-0">No doctors found. <a href="<?php echo e(route('admin.doctors.create')); ?>">Add your first doctor</a>.</p>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/sumankc/Desktop/ENT Care/resources/views/admin/doctors/index.blade.php ENDPATH**/ ?>